<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="yes" encoding="utf-8" omit-xml-declaration="yes"/>

	<xsl:variable name="tab" select="'&#09;'" />
	
	<xsl:key name="distinct-tool" match="ToolStation/@ToolStnNo" use="."/>

	<xsl:template match="SetupSheetData/ReportHeading">
		<html>
			<head>
				<basefont face="Verdana"/>
   </head>
   <body>
    <BR/>
     <TABLE align="center">
       <TR align="center">
         <TD style="FONT: 23pt Times">
                 <B>SOLIDWORKS CAM (Powered by CAMWorks)</B>
         </TD>
       </TR>

    <!--<xsl:for-each select="./Heading">
      <TR  align="center">
        <TD style="FONT: 23pt Times">
          <xsl:value-of select="."/>
        </TD>
      </TR>
    </xsl:for-each>-->

     </TABLE>
	 <!--<table border="0" align="center" cellpadding="0" width="0%" height="0">
            
			<th colspan = "2" align="center">
						
									<xsl:for-each select="*">
									<xsl:if test="name() = 'rep_TurnTool'">
			<xsl:variable name = "imageUrl3">
				<xsl:value-of select="@ToolImagePath"/>
			</xsl:variable>
			<xsl:if test="$imageUrl3 !=''">
			<xsl:text disable-output-escaping="yes">&lt;img src="</xsl:text>
			<xsl:value-of select="$imageUrl3"/>
			<xsl:text disable-output-escaping="yes">"&#160;WIDTH="70%" HEIGHT="100" align="center" /&gt;</xsl:text>
			<P align="center"><font size="5" color="#01106D"><B></B></font></P>
				</xsl:if>
				</xsl:if>
				</xsl:for-each> 
	   </th>
            </table>-->
	 
     <BR/>
   </body>
  </html>
	</xsl:template>

	<xsl:template match="SetupSheetData/Data">
	<html>

		<STYLE>
		  BODY
		  {
		  BACKGROUND-POSITION: right bottom;
		  BACKGROUND-ATTACHMENT: fixed;
		  MARGIN-LEFT: 10pt;
		  background-color:#ffffff;
		  BACKGROUND-REPEAT: no-repeat;
		  }

		  .WIPImg
		  {
		  BORDER-RIGHT:#e0dee3  1px solid;
		  BORDER-TOP:#e0dee3  1px solid;
		  BORDER-LEFT:#e0dee3  1px solid;
		  BORDER-BOTTOM:#e0dee3  1px solid;
		  BORDER-COLOR: #e0dee3;
		  CURSOR: hand;
		  }

		  .WIPImgMouseOver
		  {
		  BORDER-RIGHT:#6666ff  1px solid;
		  BORDER-TOP:#6666ff  1px solid;
		  BORDER-LEFT:#6666ff  1px solid;
		  BORDER-BOTTOM:#6666ff  1px solid;
		  BORDER-COLOR: #6666ff;
		  CURSOR: hand;
		  }

		  .EE
		  {
		  BORDER-RIGHT:#e0dee3  1px solid;
		  BORDER-TOP:#e0dee3  1px solid;
		  BORDER-LEFT:#e0dee3  1px solid;
		  BORDER-BOTTOM:#e0dee3  1px solid;
		  BORDER-COLLAPSE: collapse;
		  EMPTY-CELLS: show;
		  FONT: 10 pt;
		  COLOR: BLACK;
		  BORDER-COLOR: #e0dee3;
		  }
		  .EE TD
		  {
		  BORDER-TOP:#e0dee3  1px solid;
		  PADDING-RIGHT: 5px;
		  PADDING-LEFT: 5px;
		  HEIGHT: 23px;
		  FONT: 8pt verdana;
		  BORDER-COLOR: #e0dee3;
		  }

		  .EE TH
		  {
		  PADDING-RIGHT: 5px;
		  BORDER-TOP: #e0dee3 1px solid;
		  PADDING-LEFT: 5px;
		  HEIGHT: 23px;
		  font-style:strong;
		  BORDER-COLOR: #e0dee3;
		  }

		  .clsResultSummary
		  {
		  BORDER-RIGHT:#e0dee3  1px solid;
		  BORDER-TOP:#e0dee3  1px solid;
		  BORDER-LEFT:#e0dee3  1px solid;
		  BORDER-BOTTOM:#e0dee3  1px solid;
		  BORDER-COLLAPSE: collapse;
		  EMPTY-CELLS: show;
		  FONT: 8 pt;
		  COLOR: BLACK;
		  BORDER-COLOR: #e0dee3;
		  }
		  .clsResultSummary TD
		  {
		  PADDING-RIGHT: 5px;
		  BORDER-TOP: #e0dee3 1px solid;
		  PADDING-LEFT: 5px;
		  HEIGHT: 23px
		  }

		  .clsResultSummary TH
		  {
		  PADDING-RIGHT: 5px;
		  BORDER-TOP: #e0dee3 1px solid;
		  PADDING-LEFT: 5px;
		  HEIGHT: 23px;
		  font-style: strong;
		  font-family: Arial;
		  }

		  .DivCls
		  {
		  BORDER-RIGHT:#e0dee3  0px solid;
		  BORDER-TOP:#e0dee3  0px solid;
		  BORDER-LEFT:#e0dee3  0px solid;
		  BORDER-BOTTOM:#e0dee3  0px solid;
		  BORDER-COLLAPSE: collapse;
		  EMPTY-CELLS: show;
		  COLOR: BLACK;
		  BORDER-COLOR: #e0dee3;
		  }
		  .DivCls TD
		  {
		  PADDING-RIGHT: 0px;
		  PADDING-LEFT: 0px;
		  PADDING-TOP: 0px;
		  PADDING-BOTTOM: 0px;
		  }

		  .DivCls TH
		  {
		  PADDING-RIGHT: 0px;
		  PADDING-LEFT: 0px;
		  PADDING-TOP: 0px;
		  PADDING-BOTTOM: 0px;
		  }
		  
	  </STYLE>
			<body> 
			
			<tr><td height = "1px"><HR SIZE="3" COLOR="#5742BD"/></td></tr> 
				<BR></BR>
					<table border="0"  align="center" CELLPADDING="1"   width = "100%" bgcolor="#F0F0F0" >  
				<tr>
					<td>
				<table border="0" align="Left" CELLPADDING="5" width="100%" bgcolor="#F0F0F0">
					 
						<xsl:for-each select="*">
							   
			
							 <xsl:if test="name() = 'rep_CustomInfo'">
                <tr>
				<td  bgcolor="white"><font color="#000000"><B>Date/Time</B></font></td>
				<td  bgcolor="white"><font color="#000000"><xsl:value-of select="@CustomInfoDateTime"/></font></td>                
                </tr>
              </xsl:if>
			
							 <xsl:if test="name() = 'rep_WorkPiece'">
                <tr>
				<td  bgcolor="white"><font color="#000000"><B>Material</B></font></td>
				<td  bgcolor="white"><font color="#000000"><xsl:value-of select="@WorkPieceMaterial"/></font></td>			
                  
                </tr>
              </xsl:if>
			
						<xsl:if test="name() = 'rep_WorkPiece'">
                <tr>

					<td  bgcolor="white"><font color="#000000"><B>Stock Size</B></font></td> 
					<td  bgcolor="white">
					<font color="#000000">
					<xsl:variable name = "strProgramName">
						<xsl:value-of select="@WorkPieceTypeName"/>
						</xsl:variable>
						<xsl:if test="$strProgramName ='Cylindrical'">														
							Dia : <xsl:value-of select="@WorkPieceMaxDia"/>, Length : <xsl:value-of select="@WorkPieceLength"/>
						</xsl:if>
						
						<xsl:if test="not($strProgramName ='Cylindrical')">														
							<xsl:value-of select="@WorkPieceLength"/>, <xsl:value-of select="@WorkPieceWidth"/>, <xsl:value-of 	 				select="@WorkPieceHeight"/>
						</xsl:if>
					</font>
					</td>
                
                </tr>
              </xsl:if>
						</xsl:for-each>      
					</table>
				</td>			
          <td>
					<!--Table for Part File and related stuff-->
					<table border="0" align="Left" CELLPADDING="5" width="100%" bgcolor="#F0F0F0">
						<xsl:for-each select="*">  
							<xsl:if test="name() = 'rep_MchParams'">
                <tr>
				<td  bgcolor="white"><font color="#000000"><B>CNC Mach</B></font></td>
				<td  bgcolor="white"><font color="#000000"><xsl:value-of select="@MchName"/></font></td>
                 
                </tr>
              </xsl:if>
						
							<xsl:if test="name() = 'rep_CustomInfo'">
                <tr>
				<td  bgcolor="white"><font color="#000000"><B>Programmer</B></font></td>
				<td  bgcolor="white"><font color="#000000"><xsl:value-of select="@CustomInfoProgrammer"/></font></td>
                  
                </tr>
              </xsl:if>

							<xsl:if test="name() = 'rep_Doc'">
                <tr>
				
				<td  bgcolor="white"><font color="#000000"><B>Units</B></font></td>
				<td  bgcolor="white"><font color="#000000"><xsl:value-of select="@Unit"/></font></td>
                  
                </tr>
              </xsl:if>				  
						

						</xsl:for-each>      
					</table>
</td>

            </tr>
        </table>
					<!--End of Table for PartFile and related stuff-->
					<!--Gap between header info and operation related info-->
				
					
<BR></BR>					
<tr><td height = "1px"><HR SIZE="3" COLOR="#5742BD"/></td></tr> 
<BR></BR>

			
			
			  <table border="0" align="center" CELLPADDING="0" width="100%"  color="#FFFFFF" >	          
			  <tr><td>
				<xsl:for-each select="rep_Tooling">
					 
					  <table border="0"  align="center" CELLPADDING="5"   width = "100%" bgcolor="#F0F0F0" >
					   <tr>
							  <th bgcolor="white"><font color="#000000">Toolcrib Name: <xsl:value-of select="rep_Toolcrib/@ToolcribName"/> </font></th>
					   </tr>
						</table>
						
						<table border="0"  align="center" CELLPADDING="5"   width = "100%" bgcolor="#F0F0F0" > 
						
						<tr bgcolor="InactiveCaption">
						
								<th><font color="#000000"><B>Tool Stn No. </B></font></th>
								<th><font color="#000000"><B>Tool </B></font></th>
								<th><font color="#000000"><B>Cutting Dia.</B></font></th>
								<th><font color="#000000"><B>Flute Length</B></font></th>	
								<th><font color="#000000"><B>Protrusion</B></font></th>
								<th><font color="#000000"><B>Gage Length</B></font></th>
								<th><font color="#000000"><B>Tool Material</B></font></th>
								<th><font color="#000000"><B>Dia Offset</B></font></th>	
								<th><font color="#000000"><B>Length Offset</B></font></th>	
							 
						</tr>  
							
								<xsl:for-each select="rep_Toolcrib/rep_Toolstation"> 						
								
								<xsl:if test="ToolStation/@ToolStnNo[generate-id()=generate-id(key('distinct-tool',.))]">
									<tr>
										
										
									<td bgcolor="white"  align="Center"><font color="#000000"> <xsl:value-of select="ToolStation/@ToolStnNo"/> </font></td>
									
									<td bgcolor="white">
									<xsl:for-each select="*">
									<xsl:if test="name() = 'rep_ToolImagePath'">
									<xsl:variable name = "imageUrl">
									<xsl:value-of select="@ToolImagePath"/>
									</xsl:variable>
									<xsl:if test="$imageUrl !=''">
									<xsl:text disable-output-escaping="yes">&lt;img src="</xsl:text>
									<xsl:value-of select="$imageUrl"/>
									<xsl:text disable-output-escaping="yes">"&#160;WIDTH="50" HEIGHT="150" align="Top" hspace="50" /&gt;</xsl:text>
									</xsl:if>
									</xsl:if>
									
									</xsl:for-each>
									
									<table border="0" align="left" CELLPADDING="5" width = "100%"> 									
									  <tr>
									    <td bgcolor="white"><font color="#000000">Tool: <xsl:value-of select="rep_Tool/@ToolComment"/></font></td>
									  </tr>
								    <tr>
									    <td bgcolor="white"><font color="#000000">Holder: <xsl:value-of select="rep_MillHolderLibrary/@HolderComment"/></font></td>
									  </tr>
									</table>									
										
													
									</td>
									
									<xsl:choose>
									 <xsl:when test="rep_MillToolParams/@MinCutDia != ''">
									   <td bgcolor="white" align="center"><font color="#000000"> <xsl:value-of select=  "rep_MillToolParams/@MinCutDia"/> </font></td> 
									 </xsl:when>
									 <xsl:otherwise>
									  <td bgcolor="white" align="center"><font color="#000000"> <xsl:value-of select=  "rep_MillToolParams/@CutDia"/> </font></td> 
									 </xsl:otherwise>
								   </xsl:choose>
								   
								   <xsl:choose>
									 <xsl:when test="rep_MillToolParams/@EffAxlCutLen != ''">
									   <td bgcolor="white" align="center"><font color="#000000"> <xsl:value-of select=  "rep_MillToolParams/@EffAxlCutLen"/> </font></td> 
									 </xsl:when>
									 <xsl:otherwise>
									  <td bgcolor="white"  align="center"><font color="#000000"> <xsl:value-of select="rep_MillToolParams/@FluteLength"/> </font></td>
									 </xsl:otherwise>
								   </xsl:choose>
									
									<td bgcolor="white" align="center"><font color="#000000"> <xsl:value-of select="rep_MillToolParams/@Protrusion"/> </font></td>
									
									<td bgcolor="white" align="center"><font color="#000000"> <xsl:value-of select="ToolStation/@ToolStnGageOffsetZ"/> </font></td>
									
									<td bgcolor="white"  align="center"><font color="#000000"> <xsl:value-of select="rep_MillToolParams/@Material"/> </font></td>
									
									<td bgcolor="white" align="center"><font color="#000000"><xsl:value-of select="rep_Tool/@DiameterOffset"/> </font></td>
									
									<td bgcolor="white" align="center"><font color="#000000"><xsl:value-of select="rep_Tool/@LengthOffset"/> </font></td>
									
									</tr>
								</xsl:if>
							  </xsl:for-each>
													
					</table>
					<BR></BR>
					<BR></BR>
				</xsl:for-each>  
			
		</td></tr>
	</table>
			
		
		<!--<table class="clsResultSummary" border="1" align="center" CELLPADDING="5" width="100%" bgcolor="#FFFFFF">
			<tr><td>
			<table border="1" align="center" CELLPADDING="5" width = "100%"> 
						<tr>
								<th><font color="#000000"><B>Tooling Sheet Number </B></font></th>
						</tr>
						
						<tr>
						<xsl:for-each select="*">
								<xsl:if test="name() = 'rep_CustomInfo'">
								<td align="center"><font color="#000000"><B><xsl:value-of select="@CustomInfoPartNo"/> </B></font></td>
						</xsl:if>
								</xsl:for-each> 
						</tr>
						</table>
					</td>
					</tr>
					
		</table>
		
		<table class="clsResultSummary" border="1" align="center" CELLPADDING="5" width="100%" bgcolor="#FFFFFF">
			<tr><td>
			<table border="1" align="left" CELLPADDING="5" width = "100%"> 
						<tr>
								<th><font color="#000000"><B>Number of Sheets </B></font></th>
								<th><font color="#000000"><B>Sheet no </B></font></th>
								
						</tr>
								<xsl:for-each select="*">
								<xsl:if test="name() = 'rep_CustomInfo'">
									<td align="center"><font color="#000000"><B><xsl:value-of select="@CustomInfoGroup"/>  </B></font></td>
									<td align="center"><font color="#000000"><B><xsl:value-of select="@CustomInfoLanguage"/> </B></font></td>
								</xsl:if>
								</xsl:for-each> 
						<tr>
						
						</tr>
						</table>
					</td>
					</tr>
					
		</table>-->
		
		
		
			
          <BR></BR>
          <BR></BR>
          <BR></BR>
          <BR></BR>
          <BR></BR>
          <BR></BR>
          <BR/>
          
          <BR></BR>
					
			
				
			</body>
		</html>
	</xsl:template>


</xsl:stylesheet>